/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.tileentity;

import lotr.common.LOTRMod;
import lotr.common.tileentity.LOTRTileEntityForgeBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public abstract class LOTRTileEntityAlloyForgeBase
extends LOTRTileEntityForgeBase {
    @Override
    public int getForgeInvSize() {
        return 13;
    }

    @Override
    public void setupForgeSlots() {
        this.inputSlots = new int[]{4, 5, 6, 7};
        this.outputSlots = new int[]{8, 9, 10, 11};
        this.fuelSlot = 12;
    }

    @Override
    protected boolean canMachineInsertInput(ItemStack itemstack) {
        return itemstack != null && this.getSmeltingResult(itemstack) != null;
    }

    @Override
    public int getSmeltingDuration() {
        return 200;
    }

    @Override
    protected boolean canDoSmelting() {
        for (int i = 4; i < 8; ++i) {
            if (!this.canSmelt(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doSmelt() {
        for (int i = 4; i < 8; ++i) {
            this.smeltItemInSlot(i);
        }
    }

    private boolean canSmelt(int i) {
        ItemStack result;
        int resultSize;
        ItemStack alloyResult;
        if (this.inventory[i] == null) {
            return false;
        }
        if (this.inventory[i - 4] != null && (alloyResult = this.getAlloySmeltingResult(this.inventory[i], this.inventory[i - 4])) != null) {
            if (this.inventory[i + 4] == null) {
                return true;
            }
            resultSize = this.inventory[i + 4].field_77994_a + alloyResult.field_77994_a;
            if (this.inventory[i + 4].func_77969_a(alloyResult) && resultSize <= this.func_70297_j_() && resultSize <= alloyResult.func_77976_d()) {
                return true;
            }
        }
        if ((result = this.getSmeltingResult(this.inventory[i])) == null) {
            return false;
        }
        if (this.inventory[i + 4] == null) {
            return true;
        }
        if (!this.inventory[i + 4].func_77969_a(result)) {
            return false;
        }
        resultSize = this.inventory[i + 4].field_77994_a + result.field_77994_a;
        return resultSize <= this.func_70297_j_() && resultSize <= result.func_77976_d();
    }

    private void smeltItemInSlot(int i) {
        if (this.canSmelt(i)) {
            ItemStack alloyResult;
            boolean smeltedAlloyItem = false;
            if (this.inventory[i - 4] != null && (alloyResult = this.getAlloySmeltingResult(this.inventory[i], this.inventory[i - 4])) != null && (this.inventory[i + 4] == null || this.inventory[i + 4].func_77969_a(alloyResult))) {
                if (this.inventory[i + 4] == null) {
                    this.inventory[i + 4] = alloyResult.func_77946_l();
                } else if (this.inventory[i + 4].func_77969_a(alloyResult)) {
                    this.inventory[i + 4].field_77994_a += alloyResult.field_77994_a;
                }
                --this.inventory[i].field_77994_a;
                if (this.inventory[i].field_77994_a <= 0) {
                    this.inventory[i] = null;
                }
                --this.inventory[i - 4].field_77994_a;
                if (this.inventory[i - 4].field_77994_a <= 0) {
                    this.inventory[i - 4] = null;
                }
                smeltedAlloyItem = true;
            }
            if (!smeltedAlloyItem) {
                ItemStack result = this.getSmeltingResult(this.inventory[i]);
                if (this.inventory[i + 4] == null) {
                    this.inventory[i + 4] = result.func_77946_l();
                } else if (this.inventory[i + 4].func_77969_a(result)) {
                    this.inventory[i + 4].field_77994_a += result.field_77994_a;
                }
                --this.inventory[i].field_77994_a;
                if (this.inventory[i].field_77994_a <= 0) {
                    this.inventory[i] = null;
                }
            }
        }
    }

    public ItemStack getSmeltingResult(ItemStack itemstack) {
        boolean isStoneMaterial = false;
        Item item = itemstack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (block != null && block != Blocks.field_150350_a) {
            Material material = block.func_149688_o();
            if (material == Material.field_151576_e || material == Material.field_151595_p || material == Material.field_151571_B) {
                isStoneMaterial = true;
            }
        } else if (item == Items.field_151119_aD || item == LOTRMod.clayMug || item == LOTRMod.goldRaw || item == LOTRMod.ironRaw || item == LOTRMod.clayPlate || item == LOTRMod.ceramicPlate) {
            isStoneMaterial = true;
        }
        if (isStoneMaterial || this.isWood(itemstack)) {
            return FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
        }
        return null;
    }

    protected ItemStack getAlloySmeltingResult(ItemStack itemstack, ItemStack alloyItem) {
        if (this.isCopper(itemstack) && this.isTin(alloyItem) || this.isTin(itemstack) && this.isCopper(alloyItem)) {
            return new ItemStack(LOTRMod.bronze, 2);
        }
        return null;
    }

    protected boolean isCopper(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreCopper") || LOTRMod.isOreNameEqual(itemstack, "ingotCopper");
    }

    protected boolean isTin(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreTin") || LOTRMod.isOreNameEqual(itemstack, "ingotTin");
    }

    protected boolean isIron(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreIron") || LOTRMod.isOreNameEqual(itemstack, "ingotIron");
    }

    protected boolean isGold(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreGold") || LOTRMod.isOreNameEqual(itemstack, "ingotGold");
    }

    protected boolean isGold1(ItemStack itemstack) {
        return itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.oreGold) || itemstack.func_77973_b() == LOTRMod.goldRaw;
    }

    protected boolean isIronRaw(ItemStack itemstack) {
        return itemstack.func_77973_b() == LOTRMod.ironRaw;
    }

    protected boolean isIron1(ItemStack itemstack) {
        return itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.oreIron) || itemstack.func_77973_b() == LOTRMod.ironRaw;
    }

    protected boolean isGoldNugget(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "nuggetGold");
    }

    protected boolean isGoldOre(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreGold");
    }

    protected boolean isIronOre(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreIron");
    }

    protected boolean isIronNugget(ItemStack itemstack) {
        return itemstack.func_77973_b() == LOTRMod.ironNugget;
    }

    protected boolean isDwarvenNugget(ItemStack itemstack) {
        return itemstack.func_77973_b() == LOTRMod.dwarvenNugget;
    }

    protected boolean isSilver(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreSilver") || LOTRMod.isOreNameEqual(itemstack, "ingotSilver");
    }

    protected boolean isSilverOre(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreSilver");
    }

    protected boolean isSilverNugget(ItemStack itemstack) {
        return itemstack.func_77973_b() == LOTRMod.silverNugget;
    }

    protected boolean isMithril(ItemStack itemstack) {
        return itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.oreMithril) || itemstack.func_77973_b() == LOTRMod.mithril;
    }

    protected boolean isMithrilPlusRaw(ItemStack itemstack) {
        return itemstack.func_77973_b() == LOTRMod.mithrilRaw;
    }

    protected boolean isMithrilPlusOre(ItemStack itemstack) {
        return itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.oreMithril2);
    }

    protected boolean isMithrilOre3(ItemStack itemstack) {
        return itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.oreMithril);
    }

    protected boolean isMithrilRaw(ItemStack itemstack) {
        return itemstack.func_77973_b() == LOTRMod.mithrilRaw;
    }

    protected boolean isMithrilOre(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreMithril");
    }

    protected boolean isMithrilOre2(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "oreMithril2");
    }

    protected boolean isMithrilNugget(ItemStack itemstack) {
        return itemstack.func_77973_b() == LOTRMod.mithrilNugget;
    }

    protected boolean isOrcSteel(ItemStack itemstack) {
        return itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.oreMorgulIron) || itemstack.func_77973_b() == LOTRMod.orcSteel;
    }

    protected boolean isWood(ItemStack itemstack) {
        return LOTRMod.isOreNameEqual(itemstack, "logWood");
    }

    protected boolean isCoal(ItemStack itemstack) {
        return itemstack.func_77973_b() == Items.field_151044_h;
    }
}

